Su_25N =  {

    Name                 =   'Su-25N',
    DisplayName            = _('Su-25N'),
	HumanCockpit = true,
	HumanCockpitPath = "./Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardLeft/",

    Picture             = "Su-25.png",
    Rate                 = 40, 
    Shape                 = "Su-25N",

    shape_table_data     =
    {
        {
            file       = 'Su-25N';
            life       = 20; 
            vis        = 3;  
            desrt    = 'Su-25-oblomok'; 
            fire       = {300, 2}; 
            username = 'Su-25N';
            index    =  WSTYPE_PLACEHOLDER;
            classname   = "lLandPlane";
			positioning = "BYNORMAL";
        },
		{
			name  		= "Su-25-oblomok";
			file  		= "Su-25-oblomok";
			fire  		= { 240, 2};
		},

    },

	net_animation = {
        0, -- front gear
        3, -- right gear
        5, -- left gear
        9, -- right flap
        10, -- left flap
        11, -- right aileron
        12, -- left aileron
        15, -- right elevator
        16, -- left elevator
        17, -- rudder

        38,    -- canopy
        115, -- gear door
        116, -- gear door
        117, -- gear door

        190, -- left (red) navigation wing-tip light
        191, -- right (green) navigation wing-tip light
        192, -- tail (white) light

        198, -- anticollision (flashing red) top light
        199, -- anticollision (flashing red) bottom light
        208, -- taxi light (white) right main gear door
    },

	mapclasskey = "P0091000025",
        attribute = {wsType_Air, wsType_Airplane, wsType_Battleplane, WSTYPE_PLACEHOLDER,
        "Battleplanes",
        },
    Categories = {
        },

    M_empty                     =  10099,    
    M_nominal                   =  12750,    
    M_max                       =  17350,   
    M_fuel_max                  =  2835,    
    H_max                       =  10000,      
	length						=	15.36,
	height						=	4.8,             
	wing_area					= 	45.1,
	wing_span					=	14.35,
	wing_type 					=   1,               
	wing_tip_pos 				= 	{ -2.7, -0.111, 7.3 },            
	flaps_maneuver              =  1,                   
	has_speedbrake              =  true,
	RCS                         =  7,                  
	IR_emission_coeff			=	0.7,	
	IR_emission_coeff_ab		=	0,                
	stores_number               =  10,                    
    CAS_min                     =  54,                 
    V_opt                       =  180,                
    V_take_off                  =  72,                
    V_land                      =  68,                 
	V_max_sea_level				=	302,	
	V_max_h						=	281,	
	Vy_max						=	70,	
	Mach_max					=	0.82,
    Ny_min                      =  -3.0,                  
    Ny_max                      =  5.9,                  
    Ny_max_e                    =  6.5,                 
    bank_angle_max              =  60,                  
    range                       =  2250,                
    thrust_sum_max              =  14856,    
    has_afteburner              =  true,
    has_differential_stabilizer =  false,
    thrust_sum_ab               =  14856,    
    average_fuel_consumption    =  0.25,                
    is_tanker                   =  false,

    tand_gear_max                               =  0.577,   
	nose_gear_pos 				                =  { 2.808, -2.16, 0 },   
	nose_gear_amortizer_direct_stroke   		=  0, 
	nose_gear_amortizer_reversal_stroke  		=  0, 
	nose_gear_amortizer_normal_weight_stroke 	=  0,   
	nose_gear_wheel_diameter 	                =  0.754,
	main_gear_pos 						 	    =  { -1, -1.950, 1.352 }, 
	main_gear_amortizer_direct_stroke	 	    =  0, 
	main_gear_amortizer_reversal_stroke  	    =  0, 
	main_gear_amortizer_normal_weight_stroke    =  0,
	main_gear_wheel_diameter 				    =  0.972, 
    brakeshute_name                          	=  4,        
	
	mechanimations = {
		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0.9, "in", 1.96 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0, "in", 1.87 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "JettisonCanopy", 0 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		HeadLights = { {
				Sequence = { {
						C = { { "Arg", 208, "to", 0, "in", 3 }, { "Arg", 209, "to", 0, "in", 3 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 0.89 }, { "Arg", 209, "set", 0.89 } }
					} },
				Transition = { "Any", "Off" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "to", 1, "in", 4 }, { "Arg", 209, "to", 1, "in", 4 } }
					} },
				Transition = { "Any", "Taxi" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "to", 1, "in", 4 }, { "Arg", 209, "to", 1, "in", 4 } }
					} },
				Transition = { "Any", "High" }
			} }
	},

    engines_count    = 2,
	engines_nozzles = { {
			diameter = 0.01,
			elevation = 0,
			exhaust_length_ab = 0.01, 
            exhaust_length_ab_K = 0.01, 
			pos = { -3.793, -0.391, -0.716 },
			smokiness_level = 0.3,
            afterburner_circles_count = 0
		}, {
			diameter = 0.01,
			elevation = 0,
			exhaust_length_ab = 0.01, 
            exhaust_length_ab_K = 0.01, 
			pos = { -3.793, -0.391, 0.716 },
			smokiness_level = 0.3,
            afterburner_circles_count = 0
		} },
	crew_members = { {
			canopy_pos = { 0, 0, 0 },
			drop_canopy_name = 34,
			ejection_seat_name = 9,
			pos = { 3.029, -0.092, 0 },
			role = "pilot",
			role_display_name = "Pilot"
		} },

	fires_pos = { { -3.084, -0.595, -0.112 }, { -1.003, 0.189, 2.237 }, { -1.618, 0.175, -2.408 }, { -0.82, 0.265, 2.774 }, { -0.82, 0.265, -2.774 }, { -0.82, 0.255, 4.274 }, { -0.82, 0.255, -4.274 }, { -2.87, -0.596, 0.754 }, { -2.87, -0.596, -0.754 }, { -1.573, 0.145, -2.172 }, { -1.924, -0.04, -1.934 } },

	chaff_flare_dispenser = { {
			dir = { 0, 1, 0 },
			pos = { -3.677, 1.012, -0.859 }
		}, {
			dir = { 0, 1, 0 },
			pos = { -3.677, 1.012, 0.859 }
		} },

    detection_range_max        = 250,
    radar_can_see_ground    =    false,
		CanopyGeometry = { -0.34202014332567, -0.58058609380733, -0.81915204428899, -0.23856595048166, 0.34202014332567 },
		    Geometry 	= {
            azimuth 	= {-145.0, 145.0},
            elevation 	= {-50.0, 90.0}
        },
	Sensors = {
		RWR = "Abstract RWR"
	},

		HumanRadio = {
			frequency = 124.0,
			modulation = MODULATION_AM
		},
		
	Guns = {gun_mount("GSh_30_2", { count = 250 },{muzzle_pos = { 5.12, -1.233, -0.318 }})

	},
	
	pylons_enumeration = { 1, 10, 2, 9, 3, 8, 4, 7, 5, 6 },
	
		Pylons =     {

        pylon(1, 0, -0.958000, -0.604000, -5.149000,
            {
                FiZ = -2,
				arg = 308,
            },
            {
				{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",arg_value = 0.5,},-- R-60M
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}",arg_value = 0.5,},-- Smoke Generator - red
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}",arg_value = 0.5,},-- Smoke Generator - green
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}",arg_value = 0.5,},-- Smoke Generator - blue
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}",arg_value = 0.5,},-- Smoke Generator - white
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}",arg_value = 0.5,},-- Smoke Generator - yellow
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}",arg_value = 0.5,},-- Smoke Generator - orange
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(2, 0, -0.827000, -0.496000, -4.383000,
            {
                FiZ = -2,
				arg = 309,
            },
            {
				{CLSID = "B-8M1 - 20 S-8OFP2"},-- B-8M1 - 20 S-8OFP2
				{CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},-- FAB-100
				{CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},-- SAB-100
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}"},-- FAB-250
				{CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}"},-- RBK-250 PTAB-2.5M
				{CLSID = "{RBK_250_275_AO_1SCH}" },					-- RBK-250-275 AO-1SCh
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"},-- FAB-500 M62
				{CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}"},-- RBK-500 PTAB-10-5
				{CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}"},-- RBK-500 PTAB-1M
				{CLSID = "{RBK_500U_OAB_2_5RT}" },					-- RBK-500U OAB-2.5RT
				{CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"},-- BetAB-500
				{CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}"},-- BetAB-500ShP
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},-- KMGU-2 - 96 AO-2.5RT
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},-- KMGU-2 - 96 PTAB-2.5KO
				{CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"},-- UB-32A - 32 S-5KO
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"},-- B-8M1 - 20 S-8KOM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"},-- B-13L - 5 S-13 OF
				{CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",arg_value = 0.5,},-- S-24B
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"},-- S-25 OFM
				{CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}"},-- B-8M1 - 20 S-8TsM
				{CLSID = "{0180F983-C14A-11d8-9897-000476191836}"},-- S-25L
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(3, 0, -0.608000, -0.465000, -3.549000,
            {
                FiZ = -2,
                arg = 310,
            },
            {
				{CLSID = "B-8M1 - 20 S-8OFP2"},-- B-8M1 - 20 S-8OFP2
				{CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},-- FAB-100
				{CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},-- SAB-100
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}"},-- FAB-250
				{CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}"},-- RBK-250 PTAB-2.5M
				{CLSID = "{RBK_250_275_AO_1SCH}" },					-- RBK-250-275 AO-1SCh
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"},-- FAB-500 M62
				{CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}"},-- RBK-500 PTAB-10-5
				{CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}"},-- RBK-500 PTAB-1M
				{CLSID = "{RBK_500U_OAB_2_5RT}" },					-- RBK-500U OAB-2.5RT
				{CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"},-- BetAB-500
				{CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}"},-- BetAB-500ShP
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},-- KMGU-2 - 96 AO-2.5RT
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},-- KMGU-2 - 96 PTAB-2.5KO
				{CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",arg_value = 0.5,},-- Kh-25ML
				{CLSID = "{0180F983-C14A-11d8-9897-000476191836}"},-- S-25L
				{CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"},-- UB-32A - 32 S-5KO
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"},-- B-8M1 - 20 S-8KOM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"},-- B-13L - 5 S-13 OF
				{CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",arg_value = 0.5,},-- S-24B
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"},-- S-25 OFM
				{CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}"},-- B-8M1 - 20 S-8TsM
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"},-- Fuel tank 800L Wing
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(4, 0, -0.398000, -0.434000, -2.776000,
            {
                FiZ = -2,
                arg = 311,
            },
            {
				{CLSID = "B-8M1 - 20 S-8OFP2"},-- B-8M1 - 20 S-8OFP2
				{CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},-- FAB-100
				{CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},-- SAB-100
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}"},-- FAB-250
				{CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}"},-- RBK-250 PTAB-2.5M
				{CLSID = "{RBK_250_275_AO_1SCH}" },					-- RBK-250-275 AO-1SCh
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"},-- FAB-500 M62
				{CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}"},-- RBK-500 PTAB-10-5
				{CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}"},-- RBK-500 PTAB-1M
				{CLSID = "{RBK_500U_OAB_2_5RT}" },					-- RBK-500U OAB-2.5RT
				{CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"},-- BetAB-500
				{CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}"},-- BetAB-500ShP
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},-- KMGU-2 - 96 AO-2.5RT
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},-- KMGU-2 - 96 PTAB-2.5KO
				{CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",arg_value = 0.5,},-- Kh-25ML
				{CLSID = "{0180F983-C14A-11d8-9897-000476191836}"},-- S-25L
				{CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"},-- UB-32A - 32 S-5KO
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"},-- B-8M1 - 20 S-8KOM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"},-- B-13L - 5 S-13 OF
				{CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",arg_value = 0.5,},-- S-24B
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"},-- S-25 OFM
				{CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}"},-- B-8M1 - 20 S-8TsM
				{CLSID = "{E92CBFE5-C153-11d8-9897-000476191836}"},-- SPPU-22-1 Gun pod
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(5, 1, -0.125000, -0.400000, -2.018000,
            {
                FiZ = -2,
                arg = 312,
            },
            {
				{CLSID = "B-8M1 - 20 S-8OFP2"},-- B-8M1 - 20 S-8OFP2
				{CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},-- FAB-100
				{CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},-- SAB-100
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}"},-- FAB-250
				{CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}"},-- RBK-250 PTAB-2.5M
				{CLSID = "{RBK_250_275_AO_1SCH}" },					-- RBK-250-275 AO-1SCh
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"},-- FAB-500 M62
				{CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}"},-- RBK-500 PTAB-10-5
				{CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}"},-- RBK-500 PTAB-1M
				{CLSID = "{RBK_500U_OAB_2_5RT}" },					-- RBK-500U OAB-2.5RT
				{CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"},-- BetAB-500
				{CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}"},-- BetAB-500ShP
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},-- KMGU-2 - 96 AO-2.5RT
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},-- KMGU-2 - 96 PTAB-2.5KO
				{CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",arg_value = 0.7,connector = "hardpoint_AKU_58-5"},-- Kh-29L
				{CLSID = "{0180F983-C14A-11d8-9897-000476191836}"},-- S-25L
				{CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"},-- UB-32A - 32 S-5KO
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"},-- B-8M1 - 20 S-8KOM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"},-- B-13L - 5 S-13 OF
				{CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",arg_value = 0.5,},-- S-24B
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"},-- S-25 OFM
				{CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}"},-- B-8M1 - 20 S-8TsM
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"},-- Fuel tank 800L Wing
				{CLSID = "{E92CBFE5-C153-11d8-9897-000476191836}"},-- SPPU-22-1 Gun pod
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(6, 1, -0.125000, -0.400000, 2.018000,
            {
                FiZ = -2,
                arg = 314,
            },
            {
				{CLSID = "B-8M1 - 20 S-8OFP2"},-- B-8M1 - 20 S-8OFP2
				{CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},-- FAB-100
				{CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},-- SAB-100
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}"},-- FAB-250
				{CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}"},-- RBK-250 PTAB-2.5M
				{CLSID = "{RBK_250_275_AO_1SCH}" },					-- RBK-250-275 AO-1SCh
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"},-- FAB-500 M62
				{CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}"},-- RBK-500 PTAB-10-5
				{CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}"},-- RBK-500 PTAB-1M
				{CLSID = "{RBK_500U_OAB_2_5RT}" },					-- RBK-500U OAB-2.5RT
				{CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"},-- BetAB-500
				{CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}"},-- BetAB-500ShP
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},-- KMGU-2 - 96 AO-2.5RT
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},-- KMGU-2 - 96 PTAB-2.5KO
				{CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",arg_value = 0.7,connector = "hardpoint_AKU_58-6"},-- Kh-29L
				{CLSID = "{0180F983-C14A-11d8-9897-000476191836}"},-- S-25L
				{CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"},-- UB-32A - 32 S-5KO
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"},-- B-8M1 - 20 S-8KOM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"},-- B-13L - 5 S-13 OF
				{CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",arg_value = 0.5,},-- S-24B
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"},-- S-25 OFM
				{CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}"},-- B-8M1 - 20 S-8TsM
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"},-- Fuel tank 800L Wing
				{CLSID = "{E92CBFE5-C153-11d8-9897-000476191836}"},-- SPPU-22-1 Gun pod
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(7, 0, -0.398000, -0.434000, 2.776000,
            {
                FiZ = -2,
                arg = 315,
            },
            {
				{CLSID = "B-8M1 - 20 S-8OFP2"},-- B-8M1 - 20 S-8OFP2
				{CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},-- FAB-100
				{CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},-- SAB-100
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}"},-- FAB-250
				{CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}"},-- RBK-250 PTAB-2.5M
				{CLSID = "{RBK_250_275_AO_1SCH}" },					-- RBK-250-275 AO-1SCh
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"},-- FAB-500 M62
				{CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}"},-- RBK-500 PTAB-10-5
				{CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}"},-- RBK-500 PTAB-1M
				{CLSID = "{RBK_500U_OAB_2_5RT}" },					-- RBK-500U OAB-2.5RT
				{CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"},-- BetAB-500
				{CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}"},-- BetAB-500ShP
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},-- KMGU-2 - 96 AO-2.5RT
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},-- KMGU-2 - 96 PTAB-2.5KO
				{CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",arg_value = 0.5,},-- Kh-25ML
				{CLSID = "{0180F983-C14A-11d8-9897-000476191836}"},-- S-25L
				{CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"},-- UB-32A - 32 S-5KO
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"},-- B-8M1 - 20 S-8KOM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"},-- B-13L - 5 S-13 OF
				{CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",arg_value = 0.5,},-- S-24B
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"},-- S-25 OFM
				{CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}"},-- B-8M1 - 20 S-8TsM
				{CLSID = "{E92CBFE5-C153-11d8-9897-000476191836}"},-- SPPU-22-1 Gun pod
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(8, 0, -0.608000, -0.465000, 3.549000,
            {
                FiZ = -2,
                arg = 316,
            },
            {
				{CLSID = "B-8M1 - 20 S-8OFP2"},-- B-8M1 - 20 S-8OFP2
				{CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},-- FAB-100
				{CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},-- SAB-100
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}"},-- FAB-250
				{CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}"},-- RBK-250 PTAB-2.5M
				{CLSID = "{RBK_250_275_AO_1SCH}" },					-- RBK-250-275 AO-1SCh
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"},-- FAB-500 M62
				{CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}"},-- RBK-500 PTAB-10-5
				{CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}"},-- RBK-500 PTAB-1M
				{CLSID = "{RBK_500U_OAB_2_5RT}" },					-- RBK-500U OAB-2.5RT
				{CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"},-- BetAB-500
				{CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}"},-- BetAB-500ShP
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},-- KMGU-2 - 96 AO-2.5RT
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},-- KMGU-2 - 96 PTAB-2.5KO
				{CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",arg_value = 0.5,},-- Kh-25ML
				{CLSID = "{0180F983-C14A-11d8-9897-000476191836}"},-- S-25L
				{CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"},-- UB-32A - 32 S-5KO
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"},-- B-8M1 - 20 S-8KOM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"},-- B-13L - 5 S-13 OF
				{CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",arg_value = 0.5,},-- S-24B
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"},-- S-25 OFM
				{CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}"},-- B-8M1 - 20 S-8TsM
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"},-- Fuel tank 800L Wing
				{CLSID = "{F75187EF-1D9E-4DA9-84B4-1A1A14A3973A}",arg_value = 0.5,},-- SPS-141
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(9, 0, -0.827000, -0.496000, 4.383000,
            {
                FiZ = -2,
                arg = 317,
            },
            {
				{CLSID = "B-8M1 - 20 S-8OFP2"},-- B-8M1 - 20 S-8OFP2
				{CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},-- FAB-100
				{CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},-- SAB-100
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}"},-- FAB-250
				{CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}"},-- RBK-250 PTAB-2.5M
				{CLSID = "{RBK_250_275_AO_1SCH}" },					-- RBK-250-275 AO-1SCh
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"},-- FAB-500 M62
				{CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}"},-- RBK-500 PTAB-10-5
				{CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}"},-- RBK-500 PTAB-1M
				{CLSID = "{RBK_500U_OAB_2_5RT}" },					-- RBK-500U OAB-2.5RT
				{CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"},-- BetAB-500
				{CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}"},-- BetAB-500ShP
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},-- KMGU-2 - 96 AO-2.5RT
				{CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},-- KMGU-2 - 96 PTAB-2.5KO
				{CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"},-- UB-32A - 32 S-5KO
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"},-- B-8M1 - 20 S-8KOM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"},-- B-13L - 5 S-13 OF
				{CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",arg_value = 0.5,},-- S-24B
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"},-- S-25 OFM
				{CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}"},-- B-8M1 - 20 S-8TsM
				{CLSID = "{0180F983-C14A-11d8-9897-000476191836}"},-- S-25L
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(10, 0, -0.958000, -0.604000, 5.149000,
            {
                FiZ = -2,
                arg = 318,
            },
            {
				{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",arg_value = 0.5,},-- R-60M
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}",arg_value = 0.5,},-- Smoke Generator - red
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}",arg_value = 0.5,},-- Smoke Generator - green
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}",arg_value = 0.5,},-- Smoke Generator - blue
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}",arg_value = 0.5,},-- Smoke Generator - white
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}",arg_value = 0.5,},-- Smoke Generator - yellow
				{CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}",arg_value = 0.5,},-- Smoke Generator - orange
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
},

	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories

    WorldID =  WSTYPE_PLACEHOLDER, 

	Failures = { {
			enable = false,
			hh = 0,
			id = "asc",
			label = "ASC",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "hydro",
			label = "HYDRO",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "l_engine",
			label = "L-ENGINE",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "r_engine",
			label = "R-ENGINE",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "eos",
			label = "EOS",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "rws",
			label = "RWS",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "ecm",
			label = "ECM",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "hud",
			label = "HUD",
			mm = 0,
			mmint = 1,
			prob = 100
		} },


	Tasks = {
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(CAS),
        aircraft_task(SEAD),
        aircraft_task(AFAC),
		aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAS),

    SFM_Data = {
		aerodynamics = 
		{
			Cy0			= 0,
			Mzalfa		= 6.6,
			Mzalfadt	= 1,
			kjx 		= 2.85,
			kjz 		= 0.00125,
			Czbe 		= -0.012,
			cx_brk = 0.06,
			cx_flap = 0.06,
			cx_gear = 0.012,
			cy_flap = 0.65,
			table_data  = {
			--      M	 Cx0		 Cya			B				B4	      Omxmax	Aldop	Cymax

				{0.0,	0.038,		0.09,			0.061,			0.0165,		0.1,	 20,	 1.40,	},
				{0.2,	0.038,		0.09,			0.061,			0.0165,		0.8,	 20,	 1.40,	},
				{0.3,	0.038,		0.09,			0.061,			0.022,		1.2,	 20,	 1.40,	},
				{0.4,	0.038,		0.09,			0.061,			0.022,		1.575,	 19,	 1.35,	},
				{0.5,	0.038,		0.09,			0.061,			0.022,		1.95,	 18,	 1.3,	},
				{0.6,	0.040,		0.09,			0.069,			0.036,		2.325,	 11,	 1.14,	},
				{0.7,	0.052,		0.09,			0.082,			0.10,		2.625,	 8,	 	 0.9,	},
				{0.8,	0.082,		0.09,			0.190,			0.16,		2.625,	 3,	 	 0.5,   },
				{1.1,	0.160,		0.09,			0.210,			0.20,		2.625,	 1,	 	 0.3    },
			}
		}, -- end of aerodynamics//
		
        engine =
        {
            Nmg    =    55.0,   
            MinRUD    =    0,  
            MaxRUD    =    1,   
            MaksRUD    =    0.999,   
            ForsRUD    =    0.99999,   
            typeng    =    0,
            hMaxEng    =    15,    
            dcx_eng    =    0.0114,    
            cemax    =    0.037,    
            cefor    =    0.037,
            dpdh_m    =    6000,   
            dpdh_f    =    14000.0,

            table_data =
            {
            --   M          Pmax
                {0.0,       0.0,0.0}, -- dummy table
                {2.0,       0.0,0.0},
            }, -- end of table_data

			extended = 
			{
               
				TSFC_max = 
				{
					M 		 = {0, 0.5, 0.8, 0.9, 1.0},
					H		 = {0, 3048, 6096, 9144, 12192},
					TSFC	 = {-- M 0      0.5     0.8       0.9     1.0
								{   0.86,  0.92,  1.012,    1.012,  1.003},--H = 0       -- SL
								{   0.86,  0.99,  1.025,    1.025,  1.016},--H = 3048    -- 10000'
								{   0.86,  0.96,  1.008,    1.008,  0.999},--H = 6096    -- 20000'
								{   0.86,  0.95,  0.984,    0.984,  0.974},--H = 9144    -- 30000'
                                {   0.86,  0.94,  0.976,    0.976,  0.967},--H = 12192   -- 40000'
					}
				},

				 TSFC_afterburner =  -- afterburning thrust specific fuel consumption by altitude and Mach number RPM  100%, 2d table
				 {
					 M 		 = {0,0.3,0.5,0.7,1.0},
					 H		 = {0,1000,3000,10000},
					 TSFC	 = {-- M 0  0.3 0.5  0.7  1.0
								 {   1,   1,  1,   1,   1},--H = 0
								 {   1,   1,  1,   1,   1},--H = 1000
								 {   1,   1,  1,   1,   1},--H = 3000
								 {   1,   1,  1,   1,   1},--H = 10000
					 }
				 },

				TSFC_throttle_responce =  -- correction to TSFC for different engine RPM, 1d table
				{
					RPM = {0, 50, 55, 75, 100},
					K   = {1, 1.05, 1.22, 1.05, 1.00},   -- Static SL TSFC now part of table above
                    --K   = {1, 1, 1, 1, 1},
				},

                thrust_max = -- thrust interpolation table by altitude and mach number, 2d table.  Modified for carrier takeoffs at/around 71 foot deck height
                {
                    M       =   {0, 0.1, 0.225, 0.23, 0.3, 0.5, 0.7, 0.8, 0.9, 1.1},
                    H       =   {0, 19, 20, 23, 24, 250, 4572, 7620, 10668, 13716, 16764, 19812},
                    thrust  =  {-- M    0     0.1    0.225   0.23,   0.3    0.5     0.7     0.8     0.9     1.1
                                {   79430.4,  75763.2,  73075.2,  73067.5,  71084.2,  70373.8,  71032.3,  71255,  70681,  65420.2 },--H = 0 (sea level)
                                {   79430.4,  75763.2,  73075.2,  73067.5,  71084.2,  70373.8,  71032.3,  71255,  70681,  65420.2 },--H = 19 (~62.3 feet)
								{   79430.4,  75763.2,  73075.2,  73067.5,  71084.2,  70373.8,  71032.3,  71255,  70681,  65420.2 },--H = 20 (~66.6 feet)
							    {   79430.4,  75763.2,  73075.2,  73067.5,  71084.2,  70373.8,  71032.3,  71255,  70681,  65420.2 },--H = 23 (~75.5 feet)
                                {   79430.4,  75763.2,  73075.2,  73067.5,  71084.2,  70373.8,  71032.3,  71255,  70681,  65420.2 },--H = 24 (~78.7 feet)
                                {   79430.4,  75763.2,  73075.2,  73067.5,  71084.2,  70373.8,  71032.3,  71255,  70681,  65420.2 },--H = 250 (820 feet)
                                {   52327.7,  49534.1,  47548.8,  47541.1,  46469.8,  47230.1,  50355.8,  100469.2,  54437.8,  57187.2 },--H = 4572 (15kft)
                                {   39970.56, 36869.76,  34809.6,  34803.84,  33692.16,  33548.16,  35784.96,  37647.36,  39713.3,  43916.2 },--H = 7620 (25kft)
                                {   20881.9,  40093.25,  21365.76,  21369.6,  22187.5,  23410.56,  25006.1,  26254.1,  27713.3,  30908.16 },--H = 10668 (35kft)
                                {   11568,   12247.68,    12817.92,   12825.6,  13127.04,   14271.36,   15732.48,   16517.76,   17473.92,   19344 },--H = 13716 (45kft)
                                {   6405.12,   6823.68,    7367.04,   7372.8,  7660.8,   8609.28,   9600,   10189.44,   10744.32,   11965.44  },--H = 16764 (55kft)
                                {   3655.68,   3920.64,    4408.32,   4416,  4671.36,   5372.16,   6167.04,   6687.36,   6986.88,   7866.24  },--H = 19812 (65kft)
                               },
                },

				  thrust_afterburner = -- afterburning thrust interpolation table by altitude and mach number, 2d table
				 {
					 M 		 = {0,	0.20,	0.21,	1.0},
					 H       =   {0, 15, 16, 23, 24, 250, 19812},
					 thrust	 = { -- M 0  0.3 0.5  0.7  1.0
								 {   41370,   	41370,  41370,   41370,},  -- H = 0
								 {   41370,   	41370,  41370,   41370,},  -- H = 15
								 {   750000,   	750000,  41370,   41370,}, -- H = 16
								 {   750000,   	750000,  41370,   41370,}, -- H = 23
								 {   41370,   	38060,  38060,   36813,},  -- H = 24
								 {   41370,   	38060,  38060,   36813,},  -- H = 250
								 {   1904,   	2296,  2296,   3639,},     -- H= 19812
					 }
				 },

				rpm_throttle_responce = -- required RPM according to throttle position
				{
					throttle = {0   ,0.85  ,1.0},
					RPM      = {55  ,97.2  ,100},
				},
				thrust_rpm_responce = -- thrust = K(RPM) * thrust_max(M,H)
				{
					RPM = {0  ,55   ,55.1   ,57.6   ,65.8   ,74.1   ,78.2   ,82.3   ,90.5   ,98.8   ,100},
					K   = {0  ,0.00 ,0.051  ,0.059  ,0.101  ,0.176  ,0.248  ,0.349  ,0.670  ,0.963  ,1},
				},
			},
        }, -- end of engine
    },

	Damage = {
		[0] = {
			args = { 146, 296, 297 },
			critical_damage = 10
		},
		[3] = {
			args = { 65 },
			critical_damage = 15
		},
		[8] = {
			args = { 134 },
			critical_damage = 5
		},
		[10] = {
			args = { 153 },
			critical_damage = 15
		},
		[11] = {
			args = { 167 },
			critical_damage = 3
		},
		[12] = {
			args = { 161 },
			critical_damage = 3
		},
		[15] = {
			args = { 266, 135 },
			critical_damage = 5
		},
		[16] = {
			args = { 267, 136 },
			critical_damage = 5
		},
		[25] = {
			args = { 226 },
			critical_damage = 3
		},
		[26] = {
			args = { 216 },
			critical_damage = 3
		},
		[35] = {
			args = { 225 },
			critical_damage = 10,
			deps_cells = { 25, 37 }
		},
		[36] = {
			args = { 215 },
			critical_damage = 10,
			deps_cells = { 26, 38 }
		},
		[37] = {
			args = { 228 },
			critical_damage = 3
		},
		[38] = {
			args = { 218 },
			critical_damage = 3
		},
		[43] = {
			args = { 242, 243 },
			critical_damage = 4,
			deps_cells = { 53 }
		},
		[47] = {
			args = { 236 },
			critical_damage = 3,
			deps_cells = { 51 }
		},
		[48] = {
			args = { 234 },
			critical_damage = 3,
			deps_cells = { 51 }
		},
		[51] = {
			args = { 240 },
			critical_damage = 2
		},
		[53] = {
			args = { 247, 248 },
			critical_damage = 2
		},
		[55] = {
			args = { 81 },
			critical_damage = 10,
			deps_cells = { 43, 47, 48 }
		}
	},

	DamageParts = 
	{  
		[1] = "Su-25-oblomok-wing-l", -- wing R
		[2] = "Su-25-oblomok-wing-r", -- wing L
	},
---------------------------------------------------------------------------------------------------------------------------------------------
	lights_data = {
		lights = {
			[2] = {
				lights = { {
						angle_change_rate = 1.3962634015955,
						angle_max = 0.34906585039887,
						angle_min = 0.26179938779915,
						argument = -1,
						color = { 255, 201, 125, 0.3 },
						connector = "MAIN_SPOT_PTR",
						cooldown_t = 0.45,
						intensity_max = 4000,
						movable = true,
						power_up_t = 0.9,
						typename = "Spot"
					}, {
						angle_change_rate = 1.3962634015955,
						angle_max = 0.34906585039887,
						angle_min = 0.26179938779915,
						argument = -1,
						color = { 255, 201, 125, 0.3 },
						connector = "RESERV_SPOT_PTR",
						cooldown_t = 0.45,
						intensity_max = 4000,
						movable = true,
						power_up_t = 0.9,
						typename = "Spot"
					} },
				typename = "collection"
			},
			[3] = {
				lights = { {
						argument = 192,
						color = { 1, 1, 1, 0.17 },
						connector = "BANO_0",
						range = 4.1,
						typename = "omnilight"
					}, {
						angle_max = 2.7925268031909,
						angle_min = 2.6179938779915,
						argument = 190,
						color = { 1, 0.05, 0.15, 0.17 },
						connector = "BANO_1",
						controller = "Strobe",
						mode = 0,
						period = 2.5,
						phase_shift = 0,
						power_up_t = 0.3,
						range = 12,
						reduced_flash_time = 0.333,
						typename = "Spot"
					}, {
						angle_max = 2.7925268031909,
						angle_min = 2.6179938779915,
						argument = 191,
						color = { 0, 0.894, 0.6, 0.17 },
						connector = "BANO_2",
						controller = "Strobe",
						mode = 0,
						period = 2.5,
						phase_shift = 0.5,
						power_up_t = 0.3,
						range = 12,
						reduced_flash_time = 0.333,
						typename = "Spot"
					} },
				typename = "collection"
			},
			[6] = {
				lights = { {
						angle_change_rate = -1.3962634015955,
						angle_max = 1.7453292519943,
						argument = -1,
						color = { 255, 201, 125, 0.12 },
						connector = "MAIN_SPOT_PTR",
						cooldown_t = 0.45,
						intensity_max = 750,
						movable = true,
						power_up_t = 0.9,
						typename = "Spot"
					}, {
						angle_change_rate = -1.3962634015955,
						angle_max = 1.7453292519943,
						argument = -1,
						color = { 255, 201, 125, 0.12 },
						connector = "RESERV_SPOT_PTR",
						cooldown_t = 0.45,
						intensity_max = 750,
						movable = true,
						power_up_t = 0.9,
						typename = "Spot"
					} },
				typename = "collection"
			}
		},
		typename = "collection"
	},
}

add_aircraft(Su_25N)
